<?php //error_reporting(E_ALL | E_STRICT);//デバッグ
$userid = array();$password = array();//配列初期化
require_once(dirname(__FILE__).'/function.php');//依存ファイルインクルード
####################################################################################################
##
#  【Gallery01】写真ギャラリーCMS フリー（無料）版　ver1.0.5 (2023.01.06アップデート)
#
#  画像ギャラリーのプログラムです。
#　任意のページに埋め込みギャラリーページとして運用できます。
#　ページング（ページ送り）、サムネイル生成、リンク時画像拡大機能などがあります。
#　また、PCの他にスマホ、携帯用のファイル同梱しています（sp/がスマホ、i/が携帯（ガラケー）です。）
#  改造や改変は自己責任で行ってください。
#	
#  name: K.Numata
#  HP: http://www.php-factory.net/
#
#　■□ 設定時の注意点 □■　
#　1，値（=の右側）は数字以外の文字列の場合シングルクォーテーション（'）で囲んでいます。
#　2，これをを外したり削除しないでください。後ろのセミコロン「;」も削除しないください。
#　3，またドルマーク（$）が付いている文字列は絶対に変更しないでください。
#　4，数字で設定しているものは必ず「半角数字」。※シングルクォーテーション（'）では囲まない。
#　これらを間違えるとプログラムが正常に動作しませんので注意下さい。
##
####################################################################################################
if (version_compare(PHP_VERSION, '5.1.0', '>=')) {//PHP5.1.0以上の場合のみタイムゾーンを定義
	date_default_timezone_set('Asia/Tokyo');//タイムゾーンの設定（日本以外の場合には適宜設定ください）
}

//----------------------------------------------------------------------
// 　必須設定項目 (START)
//----------------------------------------------------------------------

//■管理画面ログイン用パスワード　※必ず変更してください
$userid[]   = 'admin';   // ユーザーID
$password[] = '1397';   // パスワード

//埋め込み設置するページの文字コード(umekomi.phpでのみ使用する)
//PC、スマホ、携帯で文字コードが異なる場合は、以下1行を各ファイル内「設定ファイルインクルード」の下に記述してください。
//Shift-jisは「SJIS」、EUC-JPは「EUC-JP」と指定してください。デフォルトはUTF-8。
$encodingType = 'UTF-8';


//セッション名（任意の半角英数字のみで指定下さい）
//ログイン認証に利用するセッション名です。通常はそのままでも構いません。
//たとえば1つのサイトに当サイトのプログラムを複数設置する場合で、それぞれ別々の人間で管理するような場合には変更して下さい。
$session_name = 'Gallery01';

//----------------------------------------------------------------------
// 　必須設定項目 (END)
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// 　任意設定（必要に応じて設定してください） (START)
//----------------------------------------------------------------------

//■登録可能数上限　
//この値を超えた場合、古いものから消えていきます。負荷を考慮しある程度上限を設けていたほうが無難です。無制限にもできます。
$max_line = 2000;
//■無制限にする場合は下記のコメント「//」（スラッシュ2つ）を外して（有効化）ください。
//$max_line = '';


//■日付の区切り文字　20○○/○○/○○の「/」部分です。※半角英数字のみ
$delimiter_text = '/';

//■日付を○年○月○日と表示する（1=する、0=しない）※有効にすると上記区切り文字は無効になります。
$up_ymd_japanese = 0;

/* 以下画像処理にはGDライブラリが必要です。※たいていのサーバーであれば入ってますが無い場合はこのプログラムは使えません */

//■画像アップ時に自動縮小後の画像の幅、または高さ（縦横比を保つため横写真は横、縦写真は縦がその値となります単位はpx）
//※アップ画像が以下より大きければ縮小処理を行います。逆にそれ以下の場合は縮小処理せずそのまま保存します。
//ギャラリーをスマホ、携帯でも使用する場合、あまり大きいと容量も増すので大きくとも400～600ぐらいがベストかと。
$imgWidthHeight = 600;

//■サムネイルのサイズ（単位はpx）
//ファイル名の先頭に「 thumb_ 」が付きます。ファイルサイズの軽いサムネイルを表示したい場合に利用ください
//PC、スマホ、携帯で共通利用します。
$imgWidthHeightThumb = 200;

//■画像アップ時のJPGの画質（0～100）※jpg時のみ　数値が大きいほど→画質良→ファイルサイズ大となる
$img_quality = 80;

//■アップ画像の最大サイズ※単位はバイト　
//※デフォルトは5MB（ただしサーバーのphp.iniの設定による。上限2MBの場合有り。変更可 ※サーバマニュアル等参考）
$maxImgSize = 5024000;


/*----------------------------------------------------------------------------
以下ページング用設定

スマホ、携帯（ガラケー）は「1ページあたりの画像表示数」と「ページングの表示数」は、
ファイル内で直接指定しているので、変更したい場合は直接ファイル内で変更下さい。
-----------------------------------------------------------------------------*/

//1ページあたりの画像表示数（PCのみ）
$pagelength = 12;

//ページングの表示数（PCのみ）数値は奇数のみ（現在のページ番号の前後に均等数のナビを表示するため）
//ナビゲーション数が超えた場合デフォルトは省略文字「...」を表示。文字列は以下で変更可。
$pagerDispLength = 5;

//ナビゲーションの省略箇所のテキスト
$overPagerPattern = '...';

//ナビゲーションの「次へ」のテキスト
$pagerNext = '次へ &raquo;';

//ナビゲーションの「前へ」のテキスト
$pagerPrev = '&laquo; 前へ';


//管理画面の1ページあたりの画像表示数
$pagelengthAdmin = 21;

//----------------------------------------------------------------------
// 　任意設定（必要に応じて設定してください） (END)
//----------------------------------------------------------------------


//----------------------------------------------------------------------
// 　変数定義,初期化(START)　※基本的に変更不可
//----------------------------------------------------------------------

$file_path = dirname(__FILE__).'/data/news.dat';//データファイルのパス
$img_updir = "upimg";//画像の保存先を指定
$extensionTypeList = array('jpg','gif','png');
$messe = "";
$extension = "";
$copyright = "";

$perm_check01= " が書き込みできません。<br>パーミッションを書き込み可能なもの（「666」等<br>またはサーバのマニュアルなどを参照）に変更し、パーミッションチェックしてみてください。<br /><a href=\"admin.php?check=permission\">[変更したのでパーミッションチェックしてみる⇒]</a>";
$perm_check02= "画像保存先のパーミッションが正しくありません。<br /><strong>{$img_updir}</strong>ディレクトリに書き込み可能なパーミッション（777等またはサーバのマニュアルなどを参照）を設定してください。<br /><a href=\"admin.php?check=permission\">[変更したのでパーミッションチェックしてみる⇒]</a>";
$perm_check03= "パーミッションOK！投稿してみてください。<!--<a href=\"admin.php\">これを非表示にする</a>-->";
$warningMesse = '<center>著作権表記がありません。削除するには著作権表記削除料金（\2,000）のお支払いが必要です。<br />削除ご希望の際は当サイトよりお申し込み下さい。<br />http://www.php-factory.net/</center>';
//----------------------------------------------------------------------
// 　変数定義,初期化 (END)
//----------------------------------------------------------------------
require_once(dirname(__FILE__).'/copy.inc');?>