<?php //error_reporting(E_ALL | E_STRICT);//デバッグ用
$userid=array();$password=array();$config=array();//配列初期化
if(version_compare(PHP_VERSION, '5.1.0', '>=')) date_default_timezone_set('Asia/Tokyo');//タイムゾーン PHP5.1.0以上の場合のみ定義（日本以外の場合には適宜設定ください）
#############################################################################################################
##
#  PKOBO_Gallery01（ギャラリーCMSプログラム）ver1.0.0 (2025.11.05リリース) PHP5.1～PHP8.4.12まで動作確認済
#
#  フルリニューアルしたギャラリープログラムです。過去のギャラリープログラムとの互換性はありません。
#　ページに直接埋め込み、またはjQueryのloadで表示するためのファイルも用意しています。
#  改造や改変は自己責任で行ってください。
#	
#  不具合等がありましたら下記サイトよりお問い合わせください。
#  name: k.numata
#  PHP工房HP: https://www.php-factory.net/
##
#############################################################################################################


//----------------------------------------------------------------------
// 　任意設定（必要に応じて設定してください） (START)
//----------------------------------------------------------------------

//■管理画面ログイン情報 ※半角英数字+記号のみ（パスワードは出来る限り記号を入れるなど推測困難かつ12文字以上で設定下さい）
$userid[]   = 'admin';// ログインID
$password[] = 'j4h1gT4ah8t7';// パスワード

//セッション名（任意の半角英数字のみで指定下さい）
//ログイン認証に利用するセッション名です。通常はそのままでも構いません。
//たとえば1つのサイトに当サイトのプログラムを複数設置する場合で、それぞれ別々の人間で管理するような場合には変更して下さい。
$session_name = 'PKOBOGALLERY';

//----------------------------------------------------------------------
// 　表示用設定 (START)
//----------------------------------------------------------------------

//このプログラムはSSL環境（https）で運用する（1＝はい、0＝いいえ）
//1にした場合はセキュリティ向上のためSSL環境でのみクッキーの送受信を許可するようになります。
$conf['isssl'] = 1;

//カテゴリ機能を利用する（1＝はい、0＝いいえ）
//1にした場合は管理画面でカテゴリを追加、変更、削除出来るようになります。一覧ページではプルダウンでカテゴリごとに絞り込むことが出来ます。
$conf['cat'] = 1;

//カテゴリに画像を登録できるようにする（1＝はい、0＝いいえ）
//1にした場合はカテゴリ一覧ページ（gallery_category.php）で画像が表示されます。（カテゴリを使用しない、カテゴリ一覧ページを利用しない場合は0でOKです）
$conf['catimg'] = 0;

//■日付の表示形式
/*
記述例1，'Y/m/d' = 「2015/01/30」（デフォルト） 
記述例2，'Y/n/j' = 「2015/1/30」（0埋め無し） 
記述例3，'Y年n月j日' = 「2015年1月30日」
記述例4，'Y.n.j' = 「2015.1.30」（※区切り文字には使えない記号もありますので一般的な記号のみ使用下さい。）
*/
$dateType = 'Y/m/d';


//■画像アップ時に自動縮小後の画像の幅、または高さ（縦横比を保つため横写真は横、縦写真は縦がその値となります単位はpx）
//※アップ画像が以下より大きければ縮小処理を行います。逆にそれ以下の場合は縮小処理せずそのまま保存します。
$imgWidthHeight = 800;

//■サムネイルのサイズ（単位はpx）※画像ファイルの場合のみ自動でこのサイズでサムネイルが生成されます。
$imgWidthHeightThumb = 300;

//■画像アップ時のJPGの画質（0～100）※jpg時のみ　数値が大きいほど→画質良→ファイルサイズ大となる
$img_quality = 90;

//■アップ画像の最大サイズ※単位はバイト　
//※デフォルトは5MB（ただしサーバーのphp.iniの設定値が優先されます。php.iniのデフォルトは2MBですがサーバーにより異なります）
//php.iniの設定値の確認、変更方法などは http://www.php-factory.net/trivia/05.php をご参考下さい。
$maxImgSize = 5024000;

//■データファイルのバックアップを作成する（0=しない、1=する）
//※新規投稿時にだけbackupディレクトリ内に「backup年月日時分秒_data.dat」のファイル名で保存されます。古いものは自動で削除。下記で期間指定。
//バックアップファイルを使用する（復元する）場合は先頭の「backup年月日時分秒_」を削除し、data/内のdata.datファイルと差し替えて下さい。
$backup_copy = 0;

//■バックアップファイルを現在から何ヶ月前まで保存するか（月を1～12で指定。デフォルトは12ヶ月前分まで保存）※上記で「1」を指定した場合のみ
$del_month = 12;

//■NEWマークを表示する（0=しない、1=する）
$new_mark_dsp = 1;

//■NEWマークを表示する期間（単位は日）※1，10、60などと指定ください
//たとえば「3」に設定した場合、2015/8/25に投稿したものは2015/8/29の00：00にNEWマークが非表示となります
$new_mark_days = 10;


/*----------------------------------------------------------------------------
ページング用設定　※表示側の設定です。管理画面側は並び替えの都合上ページングはありません。
-----------------------------------------------------------------------------*/

//1ページあたりの表示数
$pagelength = 30;

//ページングの表示数 ※数値は奇数のみ可（現在のページ番号の前後に均等数のナビを表示するため）
//ナビゲーション数が超えた場合デフォルトは省略文字「...」を表示。文字列は以下で変更可。
$pagerDispLength = 5;

//ナビゲーションの省略箇所のテキスト
$overPagerPattern = '...';

//ナビゲーションの「次へ」のテキスト
$pagerNext = 'Next &raquo;';

//ナビゲーションの「前へ」のテキスト
$pagerPrev = '&laquo; Prev';

//ページング時にアンカーを設定する場合（コンテンツ部分がページ上部ではない場合にアンカーで表示箇所を指定したい場合など）
$anker_param = '';//例 #gallery

//----------------------------------------------------------------------
// 　表示用設定 (END)
//----------------------------------------------------------------------


//----------------------------------------------------------------------
// 　その他システム独自設定（基本的に変更不可）
//----------------------------------------------------------------------

//ファイルの拡張子
$extensionList = array('jpg','gif','png');
//データファイルのディレクトリパス
$dataDir = dirname(__FILE__).'/../../data';
//バックアップファイルディレクトリのパス
$backupDataDir = dirname(__FILE__).'/../../data/backup';

$dataSeparateStr = "\t";//連結文字列

//依存ファイルrequire
require_once(dirname(__FILE__) .'/function.php');//関数インクルード
require_once(dirname(__FILE__).'/copy.inc');

//セッション定義
session_save_path( dirname(__FILE__) .'/../session' );
session_name($session_name);

//【セキュリティ設定】
if($conf['isssl'] == 1) ini_set("session.cookie_secure", 1);//SSL環境でのみクッキーの送受信を許可する設定
ini_set("session.cookie_httponly", 1);
ini_set('session.gc_maxlifetime', 7200 );  // セッションの期間を延長する秒(デフォルト:1440（24分）)　※途中でのログアウト防止の為長めに設定（セキュリティは甘くなるので極端な値は禁止）


//カテゴリをセットしておく
$categorySet['gallery'] = array();
$category = listSortUser(file(dirname(__FILE__) .'/../../data/category.dat'),'none','',5,4,SORT_ASC);
foreach($category as $val){
	$arr = explode(',',$val);
	$categorySet['gallery'][$arr[0]] = $arr[3];
}
$cfilePath = dirname(__FILE__).'/copy.inc';
$warningMesse = '<center>著作権リンク（クレジット）表記がありません。削除するには著作権表記削除料金（\2,200）のお支払いが必要です。<br />削除ご希望の際は当サイトよりお申し込みください。';
$warningMesse02 = '<p style="line-height:120%;font-size:20px;">システムに許可されていない変更が行われたか重大な問題が発生したためシステムエラーが発生しました。<br />ただ、今現在表示側は問題ありませんのでご安心下さい。<br /><br />著作権リンク（クレジット）削除用ファイルが改変された可能性があります。<br />著作権リンク（クレジット）削除ご希望の場合は当サイトの該当ページのよりお申込み下さい。<br />プログラムの入れ替え等は不要で今のままの状態で復旧可能です。（投稿データや設定等もすべて維持されます）<br /><br />必要な箇所以外は特に変更していない場合でこのメーッセージが表示された場合には当サイトのお問い合わせよりご連絡をお願いします。<br />
<a href="https://www.php-factory.net/" target="_blank">PHP工房</a></p>';
?>