<?php
	require_once('../include/config.php');
	require_once('../include/admin_function.php');
	require_once('./inc.php');
	//----------------------------------------------------------------------
	//  ページ独自処理 (START)
	//----------------------------------------------------------------------

	$id = (!empty($_GET['id'])) ? ghs($_GET['id']) : exit('パラメータがありません');
	if(!is_num($id)) exit('パラメータ不正');
	$resDataArr = ID2Data($file_path,$id);
	//----------------------------------------------------------------------
	//  ページ独自処理 (END)
	//----------------------------------------------------------------------
?>
<!DOCTYPE HTML>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
<meta name="format-detection" content="telephone=no">
<meta name="robots" content="noindex,nofollow" />
<title>編集画面</title>
<link rel="stylesheet" type="text/css" href="../css/style.css">
<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
<script type="text/javascript" src="../js/jquery.easing.1.3.js"></script>
<script type="text/javascript" src="../js/common.js"></script>
</head>
<body>
<div id="container">
<h1><?php echo $titleContents;?> 編集画面</h1>
<div id="logoutBtn" class="linkBtn"><a href="?logout=true">ログアウト</a></div>
<div id="toPage" class="linkBtn"><a href="./">一覧へ戻る</a></div>
<div id="contents" class="clearfix">
<div id="leftContents">
<?php 	require_once('../include/gnav.php');?>
</div> 
  
<div id="rightContents">
<p>編集後、ページ下部の「登録」ボタンを押して下さい。（ボタンを押すまで反映されません）</p>

<form method="post" action="put.php" enctype="multipart/form-data" class="validateForm">
<?php
//トークンセット
$token = sha1(uniqid(mt_rand(), true));
$_SESSION['token'] = $token;
?>
<input type="hidden" name="token" value="<?php echo $token;//トークン発行?>" />
<input type="hidden" name="data[mode]" value="update">
<input type="hidden" name="data[id]" value="<?php echo $id;?>">
<input type="hidden" name="data[sort]" value="<?php echo rpc($resDataArr[4]);?>" />

  <table class="borderTable01">
    <tr style="display:none">
        <th><span class="yellow">登録年月日</span></th>
        <td><?php echo registYmdList($resDataArr[1]);//日付プルダウン表示?> ※未来の日付にした場合、設定日の0時～表示されます（表示予約機能）</td>
      </tr>
    <tr style="display:none">
        <th> 公開・非公開</th>
        <td><input type="hidden" name="data[public_flag]" value="0" />
          <label><input type="checkbox" name="data[public_flag]" value="1"<?php echo ($resDataArr[2] == 1) ? ' checked="checked"' : '';?> />
          （チェックで「公開」になります）</label></td>
      </tr>
      
      <tr>
        <th>カテゴリ名</th>
        <td><input type="text" size="80" name="data[title]" value="<?php echo rpc($resDataArr[3]);?>" placeholder="" required /></td>
      </tr>

<?php 
for($i=0;$i<$maxFileLimit;$i++){
	//ファイル存在判定と存在したらセット
	$upfileTag = '';
	foreach($extensionList as $val){
		$upFilePath = $img_updir.'/'.$resDataArr[0].'-'.$i.'.'.$val;
		if(file_exists($upFilePath)){
			$upfileTag .= "<br />現在のファイル<br />";
			if($val == 'jpg' || $val == 'png' || $val == 'gif' || $val == 'webp'){
				$upfileTag .= '<img src="'.$upFilePath.'?'.uniqid().'" width="100">';
			}
			$upfileTag .= '<br /><span><input type="checkbox" name="upfile_del[]" value="'.str_replace($img_updir.'/','',$upFilePath).'" /></span> 削除';
			break;
		}
	}
?>
<?php if($conf['catimg'] == 1){ ?>
<tr>
<th>画像（5MB以内）<?php echo $upfileTag;?></th>
<td><input type="file" name="data[upfile][]" /></td>
</tr>
<?php } ?>   
<?php } ?>   

<tr>
<td colspan="2"><p class="taC"><input type="submit" value="登録" class="submitBtn" /></p></td>
</tr>
</table>

</form>
<p class="pagetop linkBtn taR"><a href="#container">PAGE TOP▲</a></p>
</div>
</div>
</div>
</body>
</html>