<?php
//----------------------------------------------------------------------
// 　関数定義 (START)　
//----------------------------------------------------------------------

//HTMLエスケープ
function ghs($string) {
  return htmlspecialchars($string, ENT_QUOTES,'utf-8');
}
//数値チェック
function is_num($str) {
	if(preg_match("/^[0-9]+$/",$str)) {
		return true;   
	}else{
		return false;
	}
}
//本文丸め
function str2Format($sentence,$length = 170,$moji = '...',$strip_tags = true,$encodingType = 'UTF-8'){
	if(is_array($sentence)){
		$sentenceRes = '';
		foreach($sentence as $val){
			$sentenceRes .= $val;
		}
		$sentence = $sentenceRes;
	}
	if($length != 0){
		$sentence = ($strip_tags == true) ? strip_tags($sentence) : $sentence;
		$sentence = mb_strimwidth($sentence, 0, $length, $moji, $encodingType);
		$sentence = str_replace(array("\n","\r"),"",$sentence);
	}
	return $sentence;
}
//空判定（DBデータ変数セット専用）
function resEmptyCheck(&$str){
	return !empty($str) ? $str : "";
}
//NULLバイト除去//
function sanitizeGa($arr){
	if(is_array($arr)){
		return array_map('sanitizeGa',$arr);
	}
	return str_replace("\0","",$arr);
}
if(isset($_GET)) $_GET = sanitizeGa($_GET);//NULLバイト除去//
if(isset($_POST)) $_POST = sanitizeGa($_POST);//NULLバイト除去//
if(isset($_COOKIE)) $_COOKIE = sanitizeGa($_COOKIE);//NULLバイト除去//

//カンマのエスケープを戻す
function rpc($str){
	return str_replace("__kanma__",",",$str);
}

//パラメータチェック
function is_param($str) {
	if(preg_match("/^[a-zA-Z0-9]+$/",$str)) {
		return true;   
	}else{
		return false;   
	}
}
//NEWマーク表示処理
function newmark($base_date,$dspday=''){
	global $new_mark_dsp;
	$newDspDay = (empty($dspday)) ? 10 : $dspday;
	$now = strtotime(date('Y-m-d'));
	$set_time = strtotime("{$base_date} +{$newDspDay} day");
	if($new_mark_dsp == 1 && $now <= $set_time){
		return true;
	}else{
		return false;
	}
}
//日付フォーマットの反映
function date2FormatDate($dateType,$date){
	return date($dateType,strtotime($date));
}
//リンクタグを含む文字列からリンクタグのみを抽出する
function getHrefLink($includeLinkStr){
	$link = '';
	$tntPttrn = "<a .*?>";
	if(preg_match("/".$tntPttrn."/i",$includeLinkStr,$linkdata) !== false){
		if(!empty($linkdata[0])){
			$link = $linkdata[0];
		}
	}
	return $link;
}

//データファイルから該当データのみ抽出
function ID2Data($file_path,$id){
	if(!is_num($id)) exit('パラメータエラー');
	$lines = file($file_path);
	$existsFlag = '';
	foreach($lines as $val){
		$linesArray = explode(",",$val);
		if($id == $linesArray[0]){
			$existsFlag = 1;
			break;	
		}
	}
	return ($existsFlag == 1) ? $linesArray : exit('指定IDのデータがありません');
}

//データの並び順変更（日付順）ユーザ閲覧ページ用
function listSortUser($lines,$category='',$id='',$categoryKey=5,$sort_targetkey = 1,$sort = SORT_DESC){
	$linesTempArray=array();
	$index=array();
	$index2=array();
	$jj = 0;
	
	if($category == 'none'){
		$category = '';
	}
	elseif(isset($_GET['category']) && is_num($_GET['category'])){
		$category = $_GET['category'];
	}
	
	
	foreach($lines as $lineVal){
		$linesArray = explode(",",$lineVal);
		if($linesArray[2] == 1 && strtotime($linesArray[1]) <= strtotime(date('Y-m-d'))){//公開設定でかつ未来日付ではない場合のみ
			if($category != ''){//カテゴリ指定されていたら該当記事のみ抽出
				if($category == $linesArray[$categoryKey]){
					$linesTempArray[] = $lineVal;
				}
			}elseif(!empty($id)){
					$linesTempArray=array();
					if($id == $linesArray[0]){
						$linesTempArray[] = $lineVal;
						break;
					}
			}
			else{
				$linesTempArray[] = $lineVal;
			}
		}
	}
	
	foreach($linesTempArray as $val){
		$linesArray = explode(",",$val);
		$index[] = ($sort_targetkey == 1) ? strtotime($linesArray[$sort_targetkey]) : $linesArray[$sort_targetkey];
		$index2[] = $linesArray[0];
	}
	
	array_multisort($index,$sort,SORT_NUMERIC,$index2,SORT_DESC,SORT_NUMERIC,$linesTempArray);
	return $linesTempArray;
	
}

//ページャー関数（HTML部は変更可）
function pager($totalPage, $pageid, $pagerDispLength,$encodingType){
	global $pagerNext,$pagerPrev,$overPagerPattern,$anker_param;
	
	//カテゴリパラメータをセット
	$addParam = (isset($_GET['category'])) ? '&category='.ghs($_GET['category']) : '';
	if(isset($_GET['category']) && !is_num($_GET['category'])) exit('パラメータ不正');
	
	$pager = '';
	$next = $pageid+1;
	$prev = $pageid-1;
	$startPage =  ($pageid-floor($pagerDispLength/2)> 0) ? ($pageid-floor($pagerDispLength/2)) : 1;
	$endPage =  ($startPage> 1) ? ($pageid+floor($pagerDispLength/2)) : $pagerDispLength;
	$startPage = ($totalPage <$endPage)? $startPage-($endPage-$totalPage):$startPage;
	if($pageid != 1 ) {
		 $pager .= '<a href="?page='.$prev.$addParam.$anker_param.'">'.$pagerPrev.'</a>';
	}
	if($startPage>= 2){
		$pager .= '<a href="?page=1'.$addParam.$anker_param.'" class="btnFirst">1</a>';
		if($startPage>= 3) $pager .= '<span class="overPagerPattern">'.$overPagerPattern.'</span>'; //ドットの表示
	}
	for($i=$startPage; $i <= $endPage ; $i++){
		$class = ($pageid == $i) ? ' class="current"':"";//現在のページ番号にclass追加
		if($i <= $totalPage && $i> 0 )//1以上最大ページ数以下の場合
			$pager .= '<a href="?page='.$i.$addParam.$anker_param.'"'.$class.'>'.$i.'</a>';//ページ番号リンク表示
	}
	if($totalPage> $endPage){
		if($totalPage-1> $endPage ) $pager .= '<span class="overPagerPattern">'.$overPagerPattern.'</span>'; //ドットの表示
		$pager .= '<a href="?page='.$totalPage.$addParam.$anker_param.'" class="btnLast">'.$totalPage.'</a>';
	}
	if($pageid <$totalPage){
		$pager .= '<a href="?page='.$next.$addParam.$anker_param.'">'.$pagerNext.'</a>';
	}
	if($encodingType!='UTF-8') $pager = mb_convert_encoding($pager,"$encodingType",'UTF-8');
	return $pager;
}
//ページャー取得とページャー用カウント取得
function pager_dsp($lines,$pagelength,$pagerDispLength,$encodingType="UTF-8"){
	$totalPage = ceil(count($lines)/$pagelength);// 合計ページ数
	$pageid = (isset($_GET['page'])) ? ghs($_GET['page']) : 1;// 現在のページを取得
	if(!is_num($pageid)) exit('パラメータが不正です');
    $pagerRes['dsp'] = pager($totalPage, $pageid,$pagerDispLength,$encodingType);//ページャー部出力
	$pagerRes['index'] = ($pageid - 1) * $pagelength;//for文用カウント
	return  $pagerRes;//連想配列で返るので注意
}


function cffs2g($warningMesse02,$cfilePath){
	if(filesize($cfilePath) != 415 && filesize($cfilePath) != 410 && filesize($cfilePath) != 122 && filesize($cfilePath) != 117) exit($warningMesse02);//ASCIIモードでの転送にも対応
}
//ファイルがあった場合にパスを返す
function getFilePath($id,$img_updir,$extensionList,$i=0,$filename = ''){
	$upFilePath = array();
	foreach($extensionList as $val){
		if (file_exists($img_updir.'/'.$id.'-'.$i.$filename.'.'.$val)){
			$upFilePath['l'] = $img_updir.'/'.$id.'-'.$i.$filename.'.'.$val;
			$upFilePath['s'] = $img_updir.'/'.$id.'-'.$i.$filename.'s.'.$val;
			break;
		}
	}
	return $upFilePath;
}
//現在の絶対URLを返す
function getCurrentUrl(){
	//(empty($_SERVER["HTTPS"]) ? "http://" : "https://") . h($_SERVER["HTTP_HOST"]) . h($_SERVER["REQUEST_URI"]);
	
	$url['url'] = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . ghs($_SERVER["HTTP_HOST"]) . ghs($_SERVER["REQUEST_URI"]);
	$url['host'] = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . ghs($_SERVER["HTTP_HOST"]);
	
	$arr = explode('/',$url['url']);
	$url['linkfile'] = str_replace(end($arr),'',$url['url']);
	
	return $url;
	
}

//----------------------------------------------------------------------
// 　関数定義 (END)
//----------------------------------------------------------------------
?>