<?php
//----------------------------------------------------------------------
// ページング付き一覧ページ（投稿がどんなに増えても自動でページングを調整します）
// htmlやCSSは自由に変更下さい。既存のページへの埋め込みももちろん可能です。PHPソースコード部分をコピペください。
//----------------------------------------------------------------------
include_once("./pkobo_gallery/admin/include/config.php");//（必要に応じてパスは適宜変更下さい）
$img_updir = './pkobo_gallery/upload/gallery';//画像保存パス（必要に応じてパスは適宜変更下さい）
$file_path = './pkobo_gallery/data/gallery.dat';//データファイルのパス
$lines = listSortUser(file($file_path),'','',5,6,SORT_ASC);//（変更不可）
$pagerRes = pager_dsp($lines,$pagelength,$pagerDispLength);//ページャー生成（変更不可）
$pagerDsp = (count($lines) > $pagelength) ? '<div class="pager">'.$pagerRes['dsp'].'</div>' : '';//ページャー用タグセット（変更不可）
?>
<!DOCTYPE HTML>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" />
<meta name="format-detection" content="telephone=no">
<title>ギャラリー画像一覧</title>
<meta name="Description" content="" />
<meta name="Keywords" content="" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<style>

/*CSSは必要最低限としています。自由に変更ください。*/

/* clearfix */
.clearfix:after { content:"."; display:block; clear:both; height:0; visibility:hidden; }
.clearfix { display:inline-block; }

/* for macIE \*/
* html .clearfix { height:1%; }
.clearfix { display:block; }

#wrap {
	width:1000px;
	margin:0 auto;
	color:#555;
	line-height:120%;
	font-size:13px;
}
.box{
	margin:3px ;
	text-align:center;
	display:block;
	overflow:hidden;
	width:30%;
	height:260px;
	float:left;
}
.box a{
	text-decoration:none;	
}
.box img{
	 height:200px;
}
.newMark{
	display:inline-block;
	border:1px solid #F00;
	padding:1px 4px;
	font-size:11px;
	line-height:110%;
	background:#F00;
	color:#fff;
	border-radius:20px;
}

/* Pager style　*/
.pager{
	text-align:center;
	padding:10px;
	clear:both;
}
/*ページャーボタン*/
.pager a{
    border: 1px solid #999;
    color: #333;
    font-size: 12px;
    padding: 5px 10px 5px;
    text-decoration: none;
	margin:0 1px;
	display:inline-block;
	border-radius:3px;
}

/*現在のページのボタン*/
.pager a.current{
    background: #555;
    color: #fff;
}
.pager a:hover{
    background:#555;
    color: #fff;
}
.overPagerPattern{
	padding:0 2px ;	
}
/* /Pager style */

/*　簡易版レスポンシブ用CSS（必要最低限のみとしています。ブレークポイントも含め自由に変更下さい）　*/
@media screen and (max-width:572px) {
#wrap {
	width:98%;
}
.box{
	width:48%;
	height:220px;
}
.box img{
	 height:140px;
}

}
</style>

<!-- lightbox（必ずしもlightboxを使う必要はありません）　-->
<script src="//ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<link href="lightbox/css/lightbox.css" rel="stylesheet" />
<script src="lightbox/js/lightbox.js"></script>
<!-- /lightbox　-->

</head>
<body>
<div id="wrap">

<h3>一覧ページ（ページング付き）</h3>

<?php if(!empty($categorySet['gallery'])){ //カテゴリが登録されている場合のみプルダウンで表示する?>
<p>カテゴリ：
<select onChange="location.href=value;">
<option value="?">すべて</option>
<?php foreach($categorySet['gallery'] as $key => $val){ ?>
<option value="?category=<?php echo ghs($key);?>"<?php if(!empty($_GET['category']) && $_GET['category'] == $key) echo ' selected="selected"';?>><?php echo ghs(rpc($val));?></option>
<?php } ?>
</select>
</p>
<?php } ?>


<?php echo $pagerDsp;//ページャー表示?>


<?php if(empty($lines)){ //データが1件もない場合に表示するもの?>
<p>データがありません。</p>
<?php } ?>


<div class="clearfix">

<?php 
//画像を出力する（html部分は自由に変更ください）
for($i = $pagerRes['index']; ($i-$pagerRes['index']) < $pagelength; $i++){
	if(!empty($lines[$i])){ 
		$data = explode(',',$lines[$i]);
		$upFilePath = getFilePath($data[0],$img_updir,$extensionList,0);
		if(!empty($upFilePath['l'])){
?>

<div class="box">
<a data-lightbox="lightbox" data-title="<?php echo (!empty($categorySet['gallery'][$data[5]])) ? '<br>【'.ghs(rpc($categorySet['gallery'][$data[5]])).'】' : '';//カテゴリ名?><?php echo ghs(rpc(strip_tags($data[3])));?>" href="<?php echo $upFilePath['l'];?>?<?php echo uniqid();//キャッシュ対策?>" target="_blank">
<img src="<?php echo $upFilePath['s'];?>?<?php echo uniqid();?>" alt="<?php echo ghs(rpc($data[3]));//タイトル表示?>">
</a>
<br><?php echo date2FormatDate($dateType,$data[1]);//登録日表示?><?php if(newmark($data[1],$new_mark_days)) echo ' <span class="newMark">New!</span>';//Newマーク表示?>
<?php echo (!empty($categorySet['gallery'][$data[5]])) ? '<br>【'.ghs(rpc($categorySet['gallery'][$data[5]])).'】' : '';//カテゴリ名?>
<br><?php echo str2Format(ghs(rpc($data[3])),40);//タイトル表示?>
</div>

<?php } } } ?>

</div>

<?php echo $pagerDsp;//ページャー表示?>

<?php echo $copyright;//クレジット表記削除不可（一律2,200円のクレジット削除費用が必要です）?>

</div>   
</body>
</html>
