<?php //error_reporting(E_ALL | E_STRICT);//デバッグ用
$userid=array();$password=array();$config=array();//配列初期化
if(version_compare(PHP_VERSION, '5.1.0', '>=')) date_default_timezone_set('Asia/Tokyo');//タイムゾーン PHP5.1.0以上の場合のみ定義（日本以外の場合には適宜設定ください）
#############################################################################################################
##
#  PKOBO-News01（画像アップ・エディタ機能搭載版）PHP新着情報、お知らせプログラム
#  ver1.0.5 (2024.11.13アップデート) 
#
#  トップーページの新着情報やお知らせなどに適しています。簡易ブログとしても利用可能です。
#　インラインフレームでも良いですが、トップページに直接埋め込むことでSEOにも効果的です。
#  改造や改変は自己責任で行ってください。
#	
#  name: k.numata
#  PHP工房HP: https://www.php-factory.net/
##
#############################################################################################################

/*-------------------------------------------------------------------------------------------------------------------
* ★以下設定時の注意点　
* ・値（=の後）は数字以外の文字列（一部を除く）はダブルクオーテーション「"」、または「'」で囲んでいます。
* ・これをを外したり削除したりしないでください。後ろのセミコロン「;」も削除しないください。
* ・また先頭に「$」が付いた文字列は変更しないでください。数字の1または0で設定しているものは必ず半角数字で設定下さい。
*以上のことを間違えてしまうとプログラムが動作しなくなりますので注意下さい。
-------------------------------------------------------------------------------------------------------------------*/

//----------------------------------------------------------------------
// 　任意設定（必要に応じて設定してください） (START)
//----------------------------------------------------------------------

//■管理画面ログイン情報 ※半角英数字+記号のみ（パスワードは出来る限り記号を入れるなど推測困難かつ12文字以上で設定下さい）
$userid[]   = 'admin';// ログインID
$password[] = '13971397';// パスワード

//セッション名（任意の半角英数字のみで指定下さい）
//ログイン認証に利用するセッション名です。通常はそのままでも構いません。
//たとえば1つのサイトに当サイトのプログラムを複数設置する場合で、それぞれ別々の人間で管理するような場合には変更して下さい。
$session_name = 'PKOBONEWS';


//----------------------------------------------------------------------
// 　表示用設定 (START)
//----------------------------------------------------------------------

//詳細ページのファイルパス（トップ、一覧ページからの相対パス）全デバイス共通
$config['detailFilePath'] = 'news-detail.php';

//詳細ページをポップアップで開くかどうか（0=開かない、1=開く）
//※詳細ページを既存ページのデザイン上で反映したい場合は「0」に指定してnews-detail.phpに必要なhtmlなどを記述下さい
//※ガラケーはポップアップ不可のため通常のページ表示になります。
$config['popupFlag'] = 1;//PC用
$config['popupFlagSP'] = 0;//スマホ用。スマホはポップアップがあまり適さないので「0」をオススメします。

//■日付の表示形式
/*
記述例1，'Y/m/d' = 「2015/01/30」（デフォルト） 
記述例2，'Y/n/j' = 「2015/1/30」（0埋め無し） 
記述例3，'Y年n月j日' = 「2015年1月30日」
記述例4，'Y.n.j' = 「2015.1.30」（※区切り文字には使えない記号もありますので一般的な記号のみ使用下さい。）
*/
$dateType = 'Y/m/d';

//■日付に曜日も表示するかどうか（0=しない、1=する）
$weekDsp = 1;

//■曜日の配列（日本語、英語など自由です。順番は変更不可）
$weekArray = array('日','月','火','水','木','金','土');

//■NEWマークを表示する（0=しない、1=する）
$new_mark_dsp = 1;

//■NEWマークを表示する期間（単位は日）※1，10、60などと指定ください
//たとえば「3」に設定した場合、2015/8/25に投稿したものは2015/8/29の00：00にNEWマークが非表示となります
$new_mark_days = 10;


/*----------------------------------------------------------------------------
ページング用設定（一覧ページ「news.php」のみ）※管理画面はファイル内で直接指定してます
-----------------------------------------------------------------------------*/

//1ページあたりの表示数
$pagelength = 20;

//ページングの表示数 ※数値は奇数のみ可（現在のページ番号の前後に均等数のナビを表示するため）
//ナビゲーション数が超えた場合デフォルトは省略文字「...」を表示。文字列は以下で変更可。
$pagerDispLength = 5;

//ナビゲーションの省略箇所のテキスト
$overPagerPattern = '...';

//ナビゲーションの「次へ」のテキスト
$pagerNext = 'Next &raquo;';

//ナビゲーションの「前へ」のテキスト
$pagerPrev = '&laquo; Prev';

//----------------------------------------------------------------------
// 　表示用設定 (END)
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// 　RSS用設定 (START)
//----------------------------------------------------------------------
//RSSを使用しない場合には特に設定不要です。
//タイトル
$rss['title'] = "RSS配信ページ";
//description
$rss['description'] = "お知らせRSS配信ページです。";
//特定のカテゴリのみRSSに反映したい場合には0から始まるカテゴリ番号を指定下さい。空の場合は全カテゴリ。
$rss['category'] = '';
//----------------------------------------------------------------------
// 　RSS用設定 (END)
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// 　システム用設定 (START)
//----------------------------------------------------------------------

//■カテゴリ設定 （カテゴリ機能を使わない場合には空「 $categoryArr = array(); 」として下さい）
//※出来る限り途中で順番を変更したり削除しないで下さい。既存の投稿との紐付けが無くなるため再度選択し直す必要が出ます。
$categoryArr = array('お知らせ','重要なお知らせ');

//■画像アップ時に自動縮小後の画像の幅、または高さ（縦横比を保つため横写真は横、縦写真は縦がその値となります単位はpx）
//※アップ画像が以下より大きければ縮小処理を行います。逆にそれ以下の場合は縮小処理せずそのまま保存します。
$imgWidthHeight = 600;

//■サムネイルのサイズ（単位はpx）※画像ファイルの場合のみ自動でこのサイズでサムネイルが生成されます。
$imgWidthHeightThumb = 200;

//■画像アップ時のJPGの画質（0～100）※jpg時のみ　数値が大きいほど→画質良→ファイルサイズ大となる
$img_quality = 90;

//■アップ画像の最大サイズ※単位はバイト　
//※デフォルトは5MB（ただしサーバーのphp.iniの設定が優先されます。php.iniのデフォルトは2MBですがサーバーにより異なります）
//管理画面上部の「サーバー情報確認」にて現在のサーバーの設定値を確認できます。
//詳細、php.iniの変更方法などは http://www.php-factory.net/trivia/05.php をご参考下さい。
$maxImgSize = 5024000;

//■データファイルのバックアップを作成する（0=しない、1=する）
//※新規投稿時にだけbackupディレクトリ内に「backup年月日時分秒_data.dat」のファイル名で保存されます。古いものは自動で削除。下記で期間指定。
//ファイル自体はそれほど大きくはありませんが、サーバー容量に不安がある場合は「しない」にしてください。
//バックアップファイルを使用する（復元する）場合は先頭の「backup年月日時分秒_」を削除し、data/内のdata.datファイルと差し替えて下さい。
$backup_copy = 0;

//■バックアップファイルを現在から何ヶ月前まで保存するか（月を1～12で指定。デフォルトは3ヶ月前分まで保存）※上記で「1」を指定した場合のみ
$del_month = 3;

//■本文入力欄にエディタ機能を使用する（0=しない、1=する）
//※ブラウザにより若干挙動が違う、またスマホは対応していないため特に不要な場合はOFFにされることをおすすめします。
//ただし、途中で変更（OFFに）されると過去の投稿のhtmlなどがそのまま表示されることになるため修正が必要になります。
$useEditer = 1;

//■アップを許可するファイルの拡張子（大文字、小文字は区別されないため小文字のみでOKです）
/*
ただし、ファイルに直接リンクする形になるため、あまりマニアックな拡張子の場合、閲覧者側で問題が出る可能性があります。
つまりPDFやエクセス、ワードなどはほとんどのPCに入っているため問題ありませんが、
たとえば.psdや.aiの場合、ソフトが入ってないPCの場合当然開けませんよってことで問題が出るということです。
「'jpg','gif','png'」は自動的にimgタグで表示されますが、その他ファイルの場合にはファイルにリンクする形になります。
※画像しかアップしない場合には無視してOKです。
*/
$extensionList = array('jpg','gif','png','pdf','xlsx','xls','doc','docx','ppt','pptx');

//アップファイルの表示テキスト（ファイルへのリンク文字列です　例　<a href="ファイルへのパス">○○</a>の○○部分です）
//「'jpg','gif','png'」はimgタグで表示するため問題ありませんが、その他ファイルの場合何らかの文字列にリンク設定するしかありませんので。
//↑で許可した拡張子分だけ指定下さい。（画像以外）
//※画像しかアップしない場合には無視してOKです。
$extensionListText = array(
   'pdf' => 'PDFファイル',
   'xls' => 'エクセルファイル（xls）',
   'xlsx' => 'エクセルファイル（xlsx）',
   'doc' => 'ワードファイル（doc）',
   'docx' => 'ワードファイル（docx）',
   'ppt' => 'パワーポイントファイル（ppt）',
   'pptx' => 'パワーポイントファイル（pptx）',
);

//管理画面ヘッダ部の「サーバー情報確認」のナビを表示する（0=しない、1=する）
//※あくまでもサーバーの現在の設定値を確認するためだけのものですので運用後は非表示でも良いと思います。
$dspServerInfo = 1;

//----------------------------------------------------------------------
// 　システム用設定 (START)
//----------------------------------------------------------------------




//----------------------------------------------------------------------
// 　その他システム独自設定（基本的に変更不可）
//----------------------------------------------------------------------

//データファイルのディレクトリパス
$dataDir = dirname(__FILE__).'/../../data';
//バックアップファイルディレクトリのパス
$backupDataDir = dirname(__FILE__).'/../../data/backup';
//データファイルのパス
$file_path = dirname(__FILE__).'/../../data/data.dat';

$dataSeparateStr = "\t";//連結文字列
$linklFileCount = 1;
$maxCommentCount = 19;//本文、画像セットのMAX値
$cleditorClass = ($useEditer == 1) ? ' class="cleditor"' : '';//cleditorを使用するしないの切り替え用
$config['encodingType'] = 'UTF-8';

$detailText = '
<div id="acrbtn" style="color:#36f;cursor:pointer;line-height:150%;font-size:13px;text-decoration:underline;">注意事項、及び操作方法（はじめに必ずご確認下さい</div>
<span id="commentDescription" style="display:none;line-height:150%">
・本文とアップファイルのセットはMAX19個まで追加可能です。<br />
・アップファイルだけ、または本文だけ、またはいずれも入力無しなどでも構いません。<br />
・表示側でサムネイル表示設定をONにしている場合で1枚目のファイルが画像の場合のみサムネイルが表示されます。<br />
・アップファイルは個数が多い、またはファイル容量が大きい場合、アップに失敗し、サーバーエラーが発生することがあります。（サーバーの設定値による）<br />
・ファイルアップ時にエラーが出た場合は「編集」にて複数回に分けて行うか、画像の場合は事前に縮小した上でアップするなど下さい。<br />
・本文入力欄は文字色や文字サイズ、センタリングや左右寄せ、リンク設定などが可能です。※アイコンを参照ください。カーソルを合わせると注釈が出ます。<br />
・HTMLタグを使用したい場合は一番右側のアイコンを押してください。<br />
・IEの場合、段落はEnter、改行はShift+Enterです。<br />
・Wordやエクセルなどのテキストをそのままコピペするとうまく表示できないことがあります。一度メモ帳に貼り付けてからコピペください。<br />
・推奨ブラウザ：Firefox（おすすめ）、GoogleChrome（1文字目のみ英字入力になる不具合有り）、IE（9以上）、スマホは文字装飾未対応です。
</span>
';
$permissionExtension = '';
foreach($extensionList as $val){
	$permissionExtension .= $val.'、';
}
$permissionExtension = rtrim($permissionExtension,'、');
$cfilePath = dirname(__FILE__).'/copy.inc';
//依存ファイルrequire
require_once(dirname(__FILE__) .'/function.php');//関数インクルード
require_once(dirname(__FILE__).'/copy.inc');
$warningMesse = '<center>著作権表記がありません。削除するには著作権表記削除料金（\2,000）のお支払いが必要です。<br />削除ご希望の際は当サイトよりお申し込み下さい。<br />https://www.php-factory.net</center>';
$warningMesse02 = '<p style="line-height:120%;font-size:20px;">システムに許可されていない変更が行われたか重大な問題が発生したためシステムエラーが発生しました。<br />ただ、今現在表示側は問題ありませんのでご安心下さい。<br /><br />著作権リンクの削除を手動で行なってしまった場合にはそのままでは正常に動作しませんので<br />当サイトの該当ページの「著作権リンク削除について」よりお申込み下さい。<br />プログラムの入れ替え等は不要で今のままの状態で復旧可能ですのでご安心下さい。（投稿データや設定等もすべて維持されます）<br /><br />必要な箇所以外は特に変更していない場合でこのメーッセージが表示された場合には当サイトのお問い合わせよりご連絡をお願いします。<br />
<a href="http://www.php-factory.net/" target="_blank">PHP工房</a></p>';
?>