<?php header("Content-Type:text/html;charset=utf-8"); ?>
<?php
	require_once('./include/config.php');
	require_once('./include/admin_function.php');
//----------------------------------------------------------------------
//  ログイン認証処理 (START)
//----------------------------------------------------------------------
	session_name($session_name);
	session_start();
	authAdmin($userid,$password);
//----------------------------------------------------------------------
//  ログイン認証処理 (END)
//----------------------------------------------------------------------

	//トークンチェック（CSRF対策）
	if(empty($_SESSION['token']) || ($_SESSION['token'] !== $_POST['token'])){
		exit('ページ遷移エラー(トークン)');
	}
	//トークン破棄
	$_SESSION['token'] = '';
	
	
	$id = (isset($_POST['id'])) ? strToCommonReplace($_POST['id']) : '';
	$mode = (isset($_POST['mode'])) ? strToCommonReplace($_POST['mode']) : exit('ページ遷移エラー');
    $up_y = (isset($_POST['up_y'])) ? strToCommonReplace($_POST['up_y']) : '';
    $up_m = (isset($_POST['up_m'])) ? strToCommonReplace($_POST['up_m']) : '';
    $up_d = (isset($_POST['up_d'])) ? strToCommonReplace($_POST['up_d']) : '';
    $title = (isset($_POST['title'])) ? strToCommonReplace($_POST['title']) : '';
    $url = (isset($_POST['url'])) ? strToCommonReplace($_POST['url']) : '';
	$dspmode = (isset($_POST['dspmode'])) ? strToCommonReplace($_POST['dspmode']) : '';

    $up_ymd = (!empty($up_y)) ? $up_y."-".$up_m."-".$up_d : date('Y-m-d');

	//各記事にユニークなIDを付与　uniqid（PHP3以下）が無ければ年月日時分秒
	if($mode == "shinki"){ 
		if(function_exists('uniqid') && function_exists('mt_rand')){//PHP4以上
			$id = uniqid(mt_rand(1000,9999));//マイクロタイムにランダム接頭辞を追加（重複防止）
		}else{
			$id = date("YmdHis");
		}
	}	
		  
	$lines = file($file_path);
	$fp = fopen($file_path, "r+b") or die("ファイルオープンエラー");
	$writeData = $id. ",".$up_ymd."," .$title.",".$dspmode.",".$url.","."\n";
	// 俳他的ロック
	if (flock($fp, LOCK_EX)) {
		ftruncate($fp,0);
		rewind($fp);
		
		// 書き込み
		if($mode == "shinki"){
			fwrite($fp, $writeData);
			$messe= "【".$title."】を登録しました。";
			
			foreach($lines as $val){
				fwrite($fp, $val);
			}
		}
		elseif($mode == "update"){
			foreach($lines as $val){
				$lines_array = explode(",",$val);
				if($lines_array[0] != $id){
					 fwrite($fp, $val);
				}else{
					fwrite($fp, $writeData);
					$messe= "編集処理完了しました！ ";
				}
			}
		}
	}
	fflush($fp);
	flock($fp, LOCK_UN);
	fclose($fp);
	
	
	//バックアップ作成と削除
	if($backup_copy=='1' && $mode == "shinki"){
		backup_gen($file_path);//バックアップ作成
		$backup_del_res = backup_del($file_path);//指定月以前のバックアップファイルの削除
	}
	//登録完了で多重登録防止のリダイレクト
	header("Location: ./complete.php?id={$id}");
	exit();
	
?>