<?php

//セッションによる確認画面からの「戻る」時にフォームデータを維持する（上級者向け）※ガラケーはセッションが使えないため不可です。
//iPhoneのChromeでは戻った際の入力データがリセットされてしまうための対策です。現状その他のブラウザでは確認されていません。

/*注意事項
1，このページの拡張子は必ず.phpである必要があります。（またはhtmlをPHPとして動作させるものでもOK）
2，またセッションが使えることが大前提です。（設置サーバーをご確認下さい→一般的なレンタルサーバーであればほぼ問題ありません）
3，既存のフォームに反映する場合には下記の各項目の記述を参考にして下さい。特にフォームの種類によって記述が異なりますのでご注意下さい。
4，これに関するサポートは行なっておりませんのでご了承下さい。ご自身での設置が難しい場合はすべて有償での作業依頼として承りますのでご了承下さい。
5，最終的に入力→確認画面→戻るのページ遷移で入力（または選択）したデータが正常に反映されていることを確認して下さい。
*/

//セッションを使用するため必須の記述（必ずページの最上部に記述する必要があります。またこの上に空白行、スペース等があってもいけません（PHPのものを除く））
session_start();
function h($string) {
	return htmlspecialchars($string, ENT_QUOTES,'utf-8');//設置ページの文字コードに合わせて下さい
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>サンプル</title>
<meta name="Description" content="" />
<meta name="Keywords" content="" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<style type="text/css">
#formWrap {
	width:700px;
	margin:0 auto;
	color:#555;
	line-height:120%;
	font-size:90%;
}
table.formTable{
	width:100%;
	margin:0 auto;
	border-collapse:collapse;
}
table.formTable td,table.formTable th{
	border:1px solid #ccc;
	padding:10px;
}
table.formTable th{
	width:30%;
	font-weight:normal;
	background:#efefef;
	text-align:left;
}
</style>
</head>
<body>
<div id="formWrap">
  <h3>お問い合わせ</h3>
  <p>下記フォームに必要事項を入力後、確認ボタンを押してください。</p>
  <form method="post" action="mail.php">
    <table class="formTable">
      <tr>
        <th>ご用件</th>
        <td><select name="ご用件">
            <option value=""<?php if(isset($_SESSION['ご用件']) && $_SESSION['ご用件'] == '') echo ' selected="selected"';?>>選択してください</option>
            <option value="ご質問・お問い合わせ"<?php if(isset($_SESSION['ご用件']) && $_SESSION['ご用件'] == 'ご質問・お問い合わせ') echo ' selected="selected"';?>>ご質問・お問い合わせ</option>
            <option value="リンクについて"<?php if(isset($_SESSION['ご用件']) && $_SESSION['ご用件'] == 'リンクについて') echo ' selected="selected"';?>>リンクについて</option>
          </select></td>
      </tr>
      <tr>
        <th>お名前</th>
        <td><input size="20" type="text" name="お名前" value="<?php if(isset($_SESSION['お名前'])) echo h($_SESSION['お名前']);?>" /> ※必須</td>
      </tr>
      <tr>
        <th>電話番号（半角）</th>
        <td><input size="30" type="text" name="電話番号" value="<?php if(isset($_SESSION['電話番号'])) echo h($_SESSION['電話番号']);?>" /></td>
      </tr>
      
      <!-- 連結項目の場合ここから（かなり特殊なため間違いにご注意下さい）※連結項目が無い場合には無視して下さい　-->
      <tr>
        <th>携帯番号（半角）</th>
        <td>
        <input size="5" type="text" name="携帯番号[][-]" value="<?php if(isset($_SESSION['携帯番号'][0]['-'])) echo h($_SESSION['携帯番号'][0]['-']);?>" /> - 
        <input size="5" type="text" name="携帯番号[][-]" value="<?php if(isset($_SESSION['携帯番号'][1]['-'])) echo h($_SESSION['携帯番号'][1]['-']);?>" /> - 
        <input size="5" type="text" name="携帯番号[][]" value="<?php if(isset($_SESSION['携帯番号'][2][0])) echo h($_SESSION['携帯番号'][2][0]);?>" />
        
        </td>
      </tr>
      <tr>
        <th>〒番号（半角）</th>
        <td>
        <input size="4" type="text" name="郵便番号[][-]" value="<?php if(isset($_SESSION['郵便番号'][0]['-'])) echo h($_SESSION['郵便番号'][0]['-']);?>" /> 
        - <input size="5" type="text" name="郵便番号[][]" value="<?php if(isset($_SESSION['郵便番号'][1][0])) echo h($_SESSION['郵便番号'][1][0]);?>" />
        </td>
      </tr>
      <!-- 連結項目の場合ここまで　-->
      
      <tr>
        <th>Mail（半角）</th>
        <td><input size="30" type="text" name="Email" value="<?php if(isset($_SESSION['Email'])) echo h($_SESSION['Email']);?>" /> ※必須</td>
      </tr>
      <tr>
        <th>性別</th>
        <td><input type="radio" name="性別" value="男"<?php if(isset($_SESSION['性別']) && $_SESSION['性別'] == '男') echo ' checked="checked"';?> /> 男　
          <input type="radio" name="性別" value="女"<?php if(isset($_SESSION['性別']) && $_SESSION['性別'] == '女') echo ' checked="checked"';?> /> 女 </td>
      </tr>
      <tr>
        <th>サイトを知ったきっかけ</th>
        <td><input name="サイトを知ったきっかけ[]" type="checkbox" value="友人・知人"<?php if(isset($_SESSION['サイトを知ったきっかけ']) && in_array('友人・知人',$_SESSION['サイトを知ったきっかけ'])) echo ' checked="checked"';?> /> 友人・知人　
          <input name="サイトを知ったきっかけ[]" type="checkbox" value="検索エンジン"<?php if(isset($_SESSION['サイトを知ったきっかけ']) && in_array('検索エンジン',$_SESSION['サイトを知ったきっかけ'])) echo ' checked="checked"';?> /> 検索エンジン</td>
      </tr>
      <tr>
        <th>お問い合わせ内容<br /></th>
        <td><textarea name="お問い合わせ内容" cols="50" rows="5"><?php if(isset($_SESSION['お問い合わせ内容'])) echo h($_SESSION['お問い合わせ内容']);?></textarea></td>
      </tr>
    </table>
    <p align="center">
      <input type="submit" value="　 確認 　" />　<input type="reset" value="リセット" />
    </p>
  </form>
  <p>※IPアドレスを記録しております。いたずらや嫌がらせ等はご遠慮ください</p>
</div>
</body>
</html>